function [opt_param, opt_likeli]=sv_ho_de_vector_sur_21_nu_rirf(dep,ylag1l,ylag1nl,ylag2l,ylag2nl,ylag3l,ylag3nl,ylag4l,ylag4nl,ylag5l,ylag5nl,trans)
% PURPOSE: starting value search: smoothing parameter and threshold in
% a Vector smooth transition autoregressive model (V-STAR)
% REMARK: bivariate V-STAR (faster procedure)
% based on heuristic optimization procedures (differential evolution)
%---------------------------------------------------
%
%           dep    = dependent variable
%           ylag1l   = VAR-regressors : eq1 linear
%           ylag1nl  = VAR-regressors : eq1 non-linear
%           ylag2l   = VAR-regressors : eq2 linear
%           ylag2nl  = VAR-regressors : eq2 non-linear
%           ylag3l   = VAR-regressors : eq1 linear
%           ylag3nl  = VAR-regressors : eq1 non-linear
%           ylag4l   = VAR-regressors : eq2 linear
%           ylag4nl  = VAR-regressors : eq2 non-linear
%           ylag5l   = VAR-regressors : eq2 linear
%           ylag5nl  = VAR-regressors : eq2 non-linear
%           trans = transition variable
%
% ---------------------------------------------------
% RETURNS:
%---------------------------------------------------
%
% written by:
% Frauke Schleer
% schleer@zew.de

global_sv
restarts=1;
[junk, neqs_trans] = size(trans);
[junk,neqs]=size(dep);

pop=neqs*2*multiply;
iter_all=ceil(n_generations/pop);

nu_vec=(log(lbtp):incr:log(mtp))';
nu_vec=[nu_vec ;log(mtp)];
% threshold value
c_vec=linspace(0.7,1,length(nu_vec))';
c_vec=flipud(c_vec);

% transition variable
trans_sort=sort(trans);    % Sorted Values of transition variable
%tvar_truncated=trans_sort;

% [ind_0,junk]=find(trans_sort> 0)
[ind_0,junk]=find(trans_sort> mean(trans));
indic1=ceil(0.90*length(trans))';
if indic1(end)<ceil(ind_0(1)*1.40)
    indic=(floor(0.60*length(trans)):1:ceil(0.90*length(trans)))';
else
    indic=(floor(0.80*ind_0(1)):1:ceil(1.40*ind_0(1)));
end
tvar_truncated=trans_sort(indic,:); % Truncated sample: 30% of observations
trans_sort=tvar_truncated;


likeli_rs=NaN(restarts,1);
param_rs=cell(restarts,1);
likeli_res=NaN(iter_all*restarts,1);

iter_total=1;

orgpop_t=zeros(pop,neqs_trans);
orgpop_s=zeros(pop,neqs_trans);

likeli_old=zeros(pop,1);
likeli_new=zeros(pop,1);

for r=1:restarts
    
    targfunc_res=NaN(iter_all,1);
    
    % generate randomly inital threshold parameter
    for j=1:neqs_trans
        orgpop_t(:,j)=unifrnd_fast(tvar_truncated(1,j),tvar_truncated(end,j),pop,1);
        % speed of transiton / gamma
        orgpop_s(:,j) = -mu1 .* log(rand(pop,1));
    end
    
    %redefine gamma = exp(nu)
    orgpop_s=log(orgpop_s);
    %ensure fesability of gamma
    ind_zero=orgpop_s<=log(lbtp);
    orgpop_s(ind_zero)=log(lbtp);
    ind_mtp=orgpop_s>log(mtp);
    orgpop_s(ind_mtp)=log(mtp);
    % ensure feasability of c
    for t=1:pop
        ind=(find(orgpop_s(t,1)>=nu_vec));
        if isempty(ind) || ind(end)==1
            tvar_truncated=trans_sort(:,1);
        else
            val=(1-c_vec(ind(end)))/2;
            indic=(ceil(val*length(trans_sort)):1:ceil((1-val)*length(trans_sort)))'; %floor rounds to nearest/lowest integer
            tvar_truncated=trans_sort(indic,1);
        end
        if orgpop_t(t,1)<tvar_truncated(1)
            orgpop_t(t,1)=tvar_truncated(1);
        elseif orgpop_t(t,1)>tvar_truncated(end)
            orgpop_t(t,1)=tvar_truncated(end);
        end
    end
    
    for p=1:pop
        likeli_old(p)=vstar_estimation_sur_nu(dep,ylag1l,ylag1nl,ylag2l,ylag2nl,ylag3l,ylag3nl,ylag4l,ylag4nl,ylag5l,ylag5nl,trans,orgpop_t(p,:),orgpop_s(p,:));
    end
    
    % whos elitist?
    [likeli_el_old ,ind_el] =max(likeli_old); % values and position of elitist#
    elitist = [orgpop_t(ind_el,:) orgpop_s(ind_el,:)];
    
    iter=1;
    while iter<=iter_all
        
        randpermpop=randperm(pop);
        offspring1=[orgpop_t(randpermpop,:) orgpop_s(randpermpop,:)];
        offspring2=[orgpop_t(randpermpop([2:end 1]),:) orgpop_s(randpermpop([2:end 1]),:)];
        offspring3=[orgpop_t(randpermpop([3:end 1:2]),:) orgpop_s(randpermpop([3:end 1:2]),:)];
        
        isol=offspring1+F*(offspring2-offspring3);
        
        %stopping criteria
        orgpop=[orgpop_t orgpop_s];
        if numel(find(orgpop==isol))==(neqs*2*pop);
            break
        end
        
        % ensure feasability
        
        % gamma
        ind_zero1=isol(:,2)<=log(lbtp);
        ind_zero=[false(pop,1) ind_zero1];
        isol(ind_zero)=log(lbtp);
        ind_mtp1=isol(:,2)>log(mtp);
        ind_mtp=[false(pop,1)  ind_mtp1];
        isol(ind_mtp)=log(mtp);
        
        from_org=rand(pop,neqs_trans*2)<pi_val;
        isol(from_org)=orgpop(from_org);
        
        % thresh
        for t=1:pop
            ind=(find(isol(t,2)>=nu_vec));
            if isempty(ind) || ind(end)==1
                tvar_truncated=trans_sort;
            else
                val=(1-c_vec(ind(end)))/2;
                indic=(ceil(val*length(trans_sort)):1:ceil((1-val)*length(trans_sort)))'; %floor rounds to nearest/lowest integer
                tvar_truncated=trans_sort(indic,:);
            end
            if isol(t,1)<tvar_truncated(1)
                isol(t,1)=tvar_truncated(1);
            elseif isol(t,1)>tvar_truncated(end)
                isol(t,1)=tvar_truncated(end);
            end
        end
        
        
        for p=1:pop
            [likeli_new(p)]=vstar_estimation_sur_nu(dep,ylag1l,ylag1nl,ylag2l,ylag2nl,ylag3l,ylag3nl,ylag4l,ylag4nl,ylag5l,ylag5nl,trans,isol(p,1:neqs_trans),isol(p,neqs_trans+1:end));
        end
        
        %select survivors
        improved = likeli_new > likeli_old;
        orgpop(improved,:)=isol(improved,:);
        likeli_old(improved) = likeli_new(improved);
        
        % report new elitist
        [likeli_el_new, ind_el]=max(likeli_old);
        if likeli_el_new>likeli_el_old
            elitist=orgpop(ind_el,:);
            likeli_el_old=likeli_el_new;
            % disp([iter ev_el_old]);
        end
        
        targfunc_res(iter,1)=likeli_el_old;
        likeli_res(iter_total,1)=likeli_el_old;
        
        iter_total=iter_total+1;
        iter=iter+1;
    end
    
    likeli_rs(r,1)=likeli_el_old;
    param_rs{r}=elitist;
    
end
[opt_likeli,ind]=max(likeli_rs);
opt_param=param_rs{ind}';